<?php
/* --------------------------------------------------------------
  InvalidPreferredCategoryException.php 2021-09-20
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2021 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Modules\DashboardStatistics\Model\Exceptions;

use Exception;

class InvalidPreferredCategoryException extends Exception
{
    /**
     * Create instance.
     */
    public static function forCategory(string $category): InvalidPreferredCategoryException
    {
        return new self("$category is not a valid category");
    }
}